/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class DeleteRemoteHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        ArrayList<MenuDialogItem> listOfMaps = new ArrayList<MenuDialogItem>();
        for (String remoteName : repo.remotes()) {
            listOfMaps.add(new MenuDialogItem(remoteName));
        }
        QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), Messages.DeleteRemoteHandler_PopupTitle);
        dialog.setInput(listOfMaps);
        if (dialog.open() != -1) {
            MenuDialogItem item = (MenuDialogItem)listOfMaps.get(dialog.getReturnCode());
            DeleteRemoteHandler.deleteRemote(repo, item.getText());
        }
        return null;
    }

    public static void deleteRemote(final GitRepository repo, final String remoteName) {
        Job job = new Job(NLS.bind((String)Messages.DeleteRemoteHandler_JobName, (Object)remoteName)){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = repo.removeRemote(remoteName);
                if (status.isOK()) {
                    DeleteRemoteHandler.showSuccessToast(remoteName);
                }
                return status;
            }
        };
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
    }

    private static void showSuccessToast(final String remoteName) {
        UIJob job = new UIJob("show toast"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                final Shell shell = UIUtils.getActiveShell();
                String text = MessageFormat.format(Messages.DeleteRemoteAction_RemoteDeleted_Msg, remoteName);
                DefaultToolTip toolTip = new DefaultToolTip((Control)shell){

                    public Point getLocation(Point size, Event event) {
                        Rectangle workbenchWindowBounds = shell.getBounds();
                        int xCoord = workbenchWindowBounds.x + workbenchWindowBounds.width - size.x - 10;
                        int yCoord = workbenchWindowBounds.y + workbenchWindowBounds.height - size.y - 10;
                        return new Point(xCoord, yCoord);
                    }
                };
                toolTip.setHideDelay(3000);
                toolTip.setText(text);
                toolTip.show(new Point(0, 0));
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.setPriority(10);
        job.schedule();
    }
}

